<?php 

class Model_orders extends CI_Model
{
	public function __construct()
	{
		parent::__construct();
	}

	/* get the orders data */
	public function getOrdersData($id = null)
	{
		if($id) {
			$sql = "SELECT * FROM orders WHERE id = ?";
			$query = $this->db->query($sql, array($id));
			return $query->row_array();
		}

		$sql = "SELECT * FROM orders ORDER BY id DESC";
		$query = $this->db->query($sql);
		return $query->result_array();
	}

	// get the orders item data
	public function getOrdersItemData($order_id = null)
	{
		if(!$order_id) {
			return false;
		}

		$sql = "SELECT * FROM orders_item WHERE order_id = ?";
		$query = $this->db->query($sql, array($order_id));
		return $query->result_array();
	}
	
	// get the orders item data for report div
	public function getOrdersItemDataReport($order_id = null)
	{
		if(!$order_id) {
			return false;
		}

		$sql = "SELECT * FROM orders_item WHERE order_id = ? ORDER BY product_id DESC, material_id, color_id, cut_height DESC, cut_width DESC";
		$query = $this->db->query($sql, array($order_id));
		return $query->result_array();
	}
	
	// get the orders cnc data
	public function getOrdersCncData($order_id = null)
	{
		if(!$order_id) {
			return false;
		}

		$sql = "SELECT orders.order_no,products.name,orders_item.qty,ROUND(orders_item.cut_width, 2),ROUND(orders_item.cut_height, 2),materials.name as m_name,orders.customer_id,orders_item.id
		FROM orders_item
		JOIN orders ON orders_item.order_id=orders.id
		JOIN products ON orders_item.product_id=products.id
		JOIN materials ON orders_item.material_id=materials.id
		
		WHERE order_id = ?";
		$query = $this->db->query($sql, array($order_id));
		return $query->result_array();
	}
	
	//get Quickbook data
	public function getOrdersQBData($order_id = null)
	{
		if(!$order_id) {
			return false;
		}

		$sql = "SELECT orders.order_no, CONCAT_WS( ' || ', products.name, materials.name, colors.name ) AS Description,orders_item.qty,CONCAT( orders_item.width, ' ', 'X', ' ', orders_item.height) as size,orders_item.sqft,orders_item.amount,orders.customer_ref_number,orders.net_amount,orders.gst_amount,orders.pst_amount,orders.gross_amount,customers.customer_name,customers.address
		FROM orders_item
		JOIN orders ON orders_item.order_id=orders.id
		JOIN products ON orders_item.product_id=products.id
		JOIN materials ON orders_item.material_id=materials.id
		JOIN colors ON orders_item.color_id=colors.id
		JOIN customers ON orders.customer_id=customers.id
		WHERE order_id = ?";
		$query = $this->db->query($sql, array($order_id));
		return $query->result_array();
	}


	public function create()
	{
		$user_id = $this->session->userdata('id');
		$this->load->model('model_sequence');
		$sequence_data = $this->model_sequence->getSequenceData(1);
		$order_no = str_pad($sequence_data['last_number'], 4, '0', STR_PAD_LEFT) .'#SO';
		//$bill_no = 'BILPR-'.strtoupper(substr(md5(uniqid(mt_rand(), true)), 0, 4));
    	$data = array(
    		'order_no' => $order_no,
			'category_id' => $this->input->post('category_id'),
			'customer_id' => $this->input->post('customer_id'),
			'customer_ref_number' => $this->input->post('customer_ref_number'),
			'order_date' => $this->input->post('order_date'),
			'payment_terms_id' => $this->input->post('payment_terms_id'),
    		'sales_tax_id' => $this->input->post('sales_tax_id'),
			'delivery_date' => $this->input->post('delivery_date'),
    		'gross_amount' => $this->input->post('gross_amount_value'),
    		//'service_charge_rate' => $this->input->post('service_charge_rate'),
    		//'service_charge' => ($this->input->post('service_charge_value') > 0) ?$this->input->post('service_charge_value'):0,
    		//'vat_charge_rate' => $this->input->post('vat_charge_rate'),
    		'gst_amount' => ($this->input->post('gst_charge_value') > 0) ? $this->input->post('gst_charge_value') : 0,
			'pst_amount' => ($this->input->post('pst_charge_value') > 0) ? $this->input->post('pst_charge_value') : 0,
    		'net_amount' => $this->input->post('net_amount_value'),
			'total_quantity' => $this->input->post('total_quantity_value'),
    		'status' => 2,
    		'user_id' => $user_id
    	);

		$insert = $this->db->insert('orders', $data);
		$order_id = $this->db->insert_id();
		$last_number = $sequence_data['last_number'] + 1;
		$update_sequence = array('last_number' => $last_number);
		$this->model_sequence->update($update_sequence, 1);

		$this->load->model('model_products');

		$count_product = count($this->input->post('product'));
    	for($x = 0; $x < $count_product; $x++) {
    		$items = array(
    			'order_id' => $order_id,
    			'product_id' => $this->input->post('product')[$x],
				'material_id' => $this->input->post('material')[$x],
				'color_id' => $this->input->post('color')[$x],
    			'qty' => $this->input->post('qty')[$x],
				'width' => $this->input->post('width')[$x],
				'cut_width' => $this->input->post('cut_width')[$x],
				'height' => $this->input->post('height')[$x],
				'cut_height' => $this->input->post('cut_height')[$x],
				'sqft' => $this->input->post('sqft')[$x],
    			'rate' => $this->input->post('rate_value')[$x],
    			'amount' => $this->input->post('amount_value')[$x],
    		);

    		$this->db->insert('orders_item', $items);

    		// now decrease the stock from the product
    		$product_data = $this->model_products->getProductData($this->input->post('product')[$x]);
    		$qty = (int) $product_data['qty'] - (int) $this->input->post('qty')[$x];

    		$update_product = array('qty' => $qty);


    		$this->model_products->update($update_product, $this->input->post('product')[$x]);
    	}

		return ($order_id) ? $order_id : false;
	}

	public function countOrderItem($order_id)
	{
		if($order_id) {
			$sql = "SELECT * FROM orders_item WHERE order_id = ?";
			$query = $this->db->query($sql, array($order_id));
			return $query->num_rows();
		}
	}

	public function update($id)
	{
		if($id) {
			$user_id = $this->session->userdata('id');
			// fetch the order data 

			$data = array(
			'category_id' => $this->input->post('category_id'),
			'customer_id' => $this->input->post('customer_id'),
			'customer_ref_number' => $this->input->post('customer_ref_number'),
			'payment_terms_id' => $this->input->post('payment_terms_id'),
    		'sales_tax_id' => $this->input->post('sales_tax_id'),
    		'order_date' => $this->input->post('order_date'),
			'delivery_date' => $this->input->post('delivery_date'),
    		'gross_amount' => $this->input->post('gross_amount_value'),
    		//'service_charge_rate' => $this->input->post('service_charge_rate'),
    		//'service_charge' => ($this->input->post('service_charge_value') > 0) ?$this->input->post('service_charge_value'):0,
    		'gst_amount' => ($this->input->post('gst_charge_value') > 0) ? $this->input->post('gst_charge_value') : 0,
			'pst_amount' => ($this->input->post('pst_charge_value') > 0) ? $this->input->post('pst_charge_value') : 0,
    		'net_amount' => $this->input->post('net_amount_value'),
			'total_quantity' => $this->input->post('total_quantity_value'),
    		'status' => 2,
    		'user_id' => $user_id
	    	);

			$this->db->where('id', $id);
			$update = $this->db->update('orders', $data);

			// now the order item 
			// first we will replace the product qty to original and subtract the qty again
			$this->load->model('model_products');
			$get_order_item = $this->getOrdersItemData($id);
			foreach ($get_order_item as $k => $v) {
				$product_id = $v['product_id'];
				$material_id = $v['material_id'];
				$color_id = $v['color_id'];
    			$qty = $v['qty'];
				$width =$v['width'];
				$cut_width =$v['cut_width'];
				$height = $v['height'];
				$cut_height = $v['cut_height'];
				$sqft = $v['sqft'];
    			//$rate = $v['rate_value'];
    			//$amount = $v['amount_value'];
				// get the product 
				//$product_data = $this->model_products->getProductData($product_id);
				//$update_qty = $qty + $product_data['qty'];
				//$update_product_data = array('qty' => $update_qty);
				
				// update the product qty
				//$this->model_products->update($update_product_data, $product_id);
			}

			// now remove the order item data 
			$this->db->where('order_id', $id);
			$this->db->delete('orders_item');

			// now decrease the product qty
			$count_product = count($this->input->post('product'));
	    	for($x = 0; $x < $count_product; $x++) {
	    		$items = array(
	    		'order_id' => $id,
    			'product_id' => $this->input->post('product')[$x],
				'material_id' => $this->input->post('material')[$x],
				'color_id' => $this->input->post('color')[$x],
    			'qty' => $this->input->post('qty')[$x],
				'width' => $this->input->post('width')[$x],
				'cut_width' => $this->input->post('cut_width')[$x],
				'height' => $this->input->post('height')[$x],
				'cut_height' => $this->input->post('cut_height')[$x],
				'sqft' => $this->input->post('sqft')[$x],
    			'rate' => $this->input->post('rate_value')[$x],
    			'amount' => $this->input->post('amount_value')[$x],
				
	    		);
	    		$this->db->insert('orders_item', $items);

	    		// now decrease the stock from the product
	    		$product_data = $this->model_products->getProductData($this->input->post('product')[$x]);
	    		$qty = (int) $product_data['qty'] - (int) $this->input->post('qty')[$x];

	    		$update_product = array('qty' => $qty);
	    		$this->model_products->update($update_product, $this->input->post('product')[$x]);
	    	}

			return true;
		}
	}



	public function remove($id)
	{
		if($id) {
			$this->db->where('id', $id);
			$delete = $this->db->delete('orders');

			$this->db->where('order_id', $id);
			$delete_item = $this->db->delete('orders_item');
			return ($delete == true && $delete_item) ? true : false;
		}
	}

	public function countTotalPaidOrders()
	{
		$sql = "SELECT * FROM orders WHERE status = ?";
		$query = $this->db->query($sql, array(1));
		return $query->num_rows();
	}

}