
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      Manage
      <small>Customers</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active">Customers</li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    <!-- Small boxes (Stat box) -->
    <div class="row">
      <div class="col-md-12 col-xs-12">

        <div id="messages"></div>

        <?php if($this->session->flashdata('success')): ?>
          <div class="alert alert-success alert-dismissible" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <?php echo $this->session->flashdata('success'); ?>
          </div>
        <?php elseif($this->session->flashdata('error')): ?>
          <div class="alert alert-error alert-dismissible" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <?php echo $this->session->flashdata('error'); ?>
          </div>
        <?php endif; ?>


        <div class="box">
          <div class="box-header">
            <h3 class="box-title">Edit Customer</h3>
          </div>
          <!-- /.box-header -->
          <form role="form" action="<?php base_url('users/update') ?>" method="post" enctype="multipart/form-data">
              <div class="box-body">

                <?php echo validation_errors(); ?>

                <div class="form-group">
                  <label for="customer_name">Customer name</label>
                  <input type="text" class="form-control" id="customer_name" name="customer_name" placeholder="Enter customer name" value="<?php echo $customer_data['customer_name']; ?>"  autocomplete="off"/>
                </div>

                <div class="form-group">
                  <label for="address">Address</label>
                  <input type="text" class="form-control" id="address" name="address" placeholder="Enter Address" value="<?php echo $customer_data['address']; ?>" autocomplete="off" />
                </div>

                <div class="form-group">
                  <label for="city">City</label>
                  <input type="text" class="form-control" id="city" name="city" placeholder="Enter City" value="<?php echo $customer_data['city']; ?>" autocomplete="off" />
                </div>

                <div class="form-group">
                  <label for="state">State</label>
                  <input type="text" class="form-control" id="state" name="state" placeholder="Enter State" value="<?php echo $customer_data['state']; ?>" autocomplete="off" />
                </div>
				<div class="form-group">
                  <label for="state">Zip code</label>
                  <input type="text" class="form-control" id="zip_code" name="zip_code" placeholder="Enter Zip code" value="<?php echo $customer_data['zip_code']; ?>" autocomplete="off" />
                </div>
				<div class="form-group">
                  <label for="state">email</label>
                  <input type="text" class="form-control" id="email" name="state" placeholder="Enter email" value="<?php echo $customer_data['email']; ?>" autocomplete="off" />
                </div>
				<div class="form-group">
                  <label for="state">phone</label>
                  <input type="text" class="form-control" id="phone" name="phone" placeholder="Enter phone" value="<?php echo $customer_data['phone']; ?>" autocomplete="off" />
                </div>

                <div class="form-group">
                  <label for="contact_person">Contact Person</label>
                  <input type="text" class="form-control" id="contact_person" name="contact_person" placeholder="Enter Contact Person" value="<?php echo $customer_data['contact_person']; ?>" autocomplete="off" />
                </div>
				<div class="form-group">
                  <label for="store">tax_code_id</label>
                  <select class="form-control" id="tax_code_id" name="tax_code_id">
                    <option value="1" <?php if($customer_data['tax_code_id'] == 1) { echo "selected='selected'"; } ?>>G</option>
                    <option value="2" <?php if($customer_data['tax_code_id'] != 1) { echo "selected='selected'"; } ?>>P</option>
                  </select>
                </div>

                <div class="form-group">
                  <label for="store">Status</label>
                  <select class="form-control" id="status" name="status">
                    <option value="1" <?php if($customer_data['status'] == 1) { echo "selected='selected'"; } ?>>Active</option>
                    <option value="2" <?php if($customer_data['status'] != 1) { echo "selected='selected'"; } ?>>Unactive</option>
                  </select>
                </div>



              </div>
              <!-- /.box-body -->

              <div class="box-footer">
                <button type="submit" class="btn btn-primary">Save Changes</button>
                <a href="<?php echo base_url('users/') ?>" class="btn btn-warning">Back</a>
              </div>
            </form>
          <!-- /.box-body -->
        </div>
        <!-- /.box -->
      </div>
      <!-- col-md-12 -->
    </div>
    <!-- /.row -->
    

  </section>
  <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<script type="text/javascript">
  
  $(document).ready(function() {
    $(".select_group").select2();
    $("#description").wysihtml5();

    $("#mainCustomerNav").addClass('active');
    $("#manageCustomerNav").addClass('active');
    
    var btnCust = '<button type="button" class="btn btn-secondary" title="Add picture tags" ' + 
        'onclick="alert(\'Call your custom code here.\')">' +
        '<i class="glyphicon glyphicon-tag"></i>' +
        '</button>'; 
  });
</script>