
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      Manage
      <small>Orders</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active">Orders</li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    <!-- Small boxes (Stat box) -->
    <div class="row">
      <div class="col-md-12 col-xs-12">

        <div id="messages"></div>

        <?php if($this->session->flashdata('success')): ?>
          <div class="alert alert-success alert-dismissible" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <?php echo $this->session->flashdata('success'); ?>
          </div>
        <?php elseif($this->session->flashdata('error')): ?>
          <div class="alert alert-error alert-dismissible" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <?php echo $this->session->flashdata('error'); ?>
          </div>
        <?php endif; ?>


        <div class="box">
          <div class="box-header">
            <h3 class="box-title">Edit Order</h3>
          </div>
          <!-- /.box-header -->
          <form role="form" action="<?php base_url('orders/create') ?>" method="post" class="form-horizontal">
              <div class="box-body">

                <?php echo validation_errors(); ?>

                <div class="form-group">
                  <label for="date" class="col-sm-12 control-label">Date: <?php echo date('Y-m-d') ?>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo date('h:i a') ?></label>
                </div>

                <div class="col-md-4 col-xs-12 pull pull-left">
				
					<div class="form-group">
						<label for="order_no" class="col-sm-5 control-label" style="text-align:left;">Order Number</label>
						<div class="col-sm-7">
						<input type="text" class="form-control" id="order_no" name="order_no" disabled value="<?php echo $order_data['order']['order_no'] ?>" autocomplete="off"/>
						</div>
					</div>
				  <div class="form-group">
                  <label for="Category_id" class="col-sm-5 control-label" style="text-align:left;">Category</label>
				  <div class="col-sm-7">
                  <select class="form-control" id="category_id" name="category_id">
				  <option value=""></option>
                    <?php foreach ($category as $k => $v): ?>
                      <option value="<?php echo $v['id'] ?>" <?php if($orderdata['category_id'] == $v['id']) { echo "selected='selected'"; } ?>><?php echo $v['name'] ?></option>
                    <?php endforeach ?>
                  </select>
				  </div>
					</div>
                  <div class="form-group">
                  <label for="Customer_id" class="col-sm-5 control-label" style="text-align:left;">Customer</label>
				  <div class="col-sm-7">
                  <select class="form-control" id="customer_id" name="customer_id" onchange="getCustomerData()">
				  <option value=""></option>
                    <?php foreach ($customers as $k => $v): ?>
                      <option value="<?php echo $v['id'] ?>" <?php if($orderdata['customer_id'] == $v['id']) { echo "selected='selected'"; } ?>><?php echo $v['customer_name'] ?></option>
                    <?php endforeach ?>
                  </select>
				  </div>
					</div>
					<div class="form-group">
						<label for="Customer_ref_number" class="col-sm-5 control-label" style="text-align:left;">Customer PO</label>
						<div class="col-sm-7">
						<input type="text" class="form-control" id="customer_ref_number" name="customer_ref_number" value="<?php echo $order_data['order']['customer_ref_number'] ?>" autocomplete="off"/>
						</div>
					</div>
				  
                </div>
				<div class="col-md-4 col-xs-12 pull pull-left">
				<div class="form-group">
                  <label for="Payment_terms_id" class="col-sm-5 control-label" style="text-align:left;">Payment Terms</label>
				  <div class="col-sm-7">
                  <select class="form-control" id="payment_terms_id" name="payment_terms_id">
				  <option value=""></option>
                    <?php foreach ($terms as $k => $v): ?>
                      <option value="<?php echo $v['id'] ?>" <?php if($orderdata['payment_terms_id'] == $v['id']) { echo "selected='selected'"; } ?>><?php echo $v['name'] ?></option>
                    <?php endforeach ?>
                  </select>
				  </div>
					</div>
					<div class="form-group">
						<label for="Sales_tax_id" class="col-sm-5 control-label" style="text-align:left;">Tax Code</label>
						<div class="col-sm-7">
						<select class="form-control" id="sales_tax_id" name="sales_tax_id">
						<option value=""></option>
							<?php foreach ($tax as $k => $v): ?>
							<option value="<?php echo $v['id'] ?>" <?php if($orderdata['sales_tax_id'] == $v['id']) { echo "selected='selected'"; } ?>><?php echo $v['name'] ?></option>
							<?php endforeach ?>
						</select>
						</div>
					</div>
					<div class="form-group">
						<label for="Order_date" class="col-sm-5 control-label" style="text-align:left;">Order Date</label>
						<div class="col-sm-7">
						<div class='input-group date' id='order_date'>
						<input type="text" class="form-control" name="order_date" value="<?php echo $order_data['order']['order_date'] ?>" autocomplete="off"/>
						<span class="input-group-addon">
                        <span class="glyphicon glyphicon-calendar"></span>
						</span>
						</div>
						<script type="text/javascript">$(function () {$('#order_date').datepicker();});</script>
					</div>
					</div>
					<div class="form-group">
						<label for="Delivery_date" class="col-sm-5 control-label" style="text-align:left;">Delivery Date</label>
						<div class="col-sm-7">
						<div class='input-group date' id='delivery_date'>
						<input type="text" class="form-control" name="delivery_date" value="<?php echo $order_data['order']['delivery_date'] ?>" autocomplete="off"/>
						<span class="input-group-addon">
                        <span class="glyphicon glyphicon-calendar"></span>
						</span>
						</div>
						<script type="text/javascript">$(function () {$('#delivery_date').datepicker();});</script>
					</div>
					</div>
				</div>
				<div class="col-md-4 col-xs-12 pull pull-left">
					<div class="form-group">
						<label for="Total_quantity" class="col-sm-5 control-label" style="text-align:left;">Total Qty</label>
						<div class="col-sm-7">
						<input type="text" class="form-control" id="total_quantity" name="total_quantity" disabled value="<?php echo $order_data['order']['total_quantity'] ?>" autocomplete="off"/>
                        <input type="hidden" class="form-control" id="total_quantity_value" name="total_quantity_value" value="<?php echo $order_data['order']['total_quantity'] ?>" autocomplete="off">
						</div>
					</div>
					<div class="form-group">
						<label for="Total_sqft" class="col-sm-5 control-label" style="text-align:left;">Total Sqft</label>
						<div class="col-sm-7">
						<input type="text" class="form-control" id="total_sqft" name="total_sqft" disabled value="<?php echo $order_data['order']['total_sqft'] ?>" autocomplete="off"/>
                        <input type="hidden" class="form-control" id="total_sqft_value" name="total_sqft_value" value="<?php echo $order_data['order']['total_sqft'] ?>" autocomplete="off">
						</div>
					</div>
					<div class="form-group">
						<label for="User_id" class="col-sm-5 control-label" style="text-align:left;">User</label>
						<div class="col-sm-7">
						<input type="text" class="form-control" id="user_id" name="user_id" disabled value="<?php echo $user_data['username'] ?>" autocomplete="off"/>
						</div>
					</div>
					<div class="form-group">
                    <label for="Status" class="col-sm-5 control-label" style="text-align:left;">Status</label>
                    <div class="col-sm-7">
                      <select type="text" class="form-control" id="status" name="status">
                        <option value=""></option>
						<option value="1" <?php if($order_data['order']['status'] == 1) { echo "selected='selected'"; } ?>>In Process</option>
                        <option value="2" <?php if($order_data['order']['status'] != 1) { echo "selected='selected'"; } ?>>Complete</option>
                       
					 </select>
                    </div>
                  </div>
				</div>
                
                
                <br /> <br/>
                <table class="table table-bordered" id="product_info_table">
                  <thead>
                    <tr>
                      <th style="width:9%">Product</th>
					  <th style="width:9%">Material</th>
					  <th style="width:9%">Color</th>
					  <th style="width:9%">UOL</th>
                      <th style="width:9%">Qty</th>
					  <th style="width:9%">Width</th>
					  <th style="width:9%">Height</th>
					  <th style="width:9%">SqFt</th>
                      <th style="width:9%">Rate</th>
					  <th style="width:9%">Per</th>
                      <th style="width:9%">Amount</th>
                      <th style="width:10%"><button type="button" id="add_row" class="btn btn-default"><i class="fa fa-plus"></i></button></th>
                    </tr>
                  </thead>

                   <tbody>

                    <?php if(isset($order_data['order_item'])): ?>
                      <?php $x = 1; ?>
                      <?php foreach ($order_data['order_item'] as $key => $val): ?>
                        <?php //print_r($v); ?>
                       <tr id="row_<?php echo $x; ?>">
                         <td>
                          <select class="form-control product" data-row-id="row_<?php echo $x; ?>" id="product_<?php echo $x; ?>" name="product[]" style="width:100%;" onchange="getSqFt(<?php echo $x; ?>)" required>
                              <option value=""></option>
                              <?php foreach ($products as $k => $v): ?>
                                <option value="<?php echo $v['id'] ?>" <?php if($val['product_id'] == $v['id']) { echo "selected='selected'"; } ?>><?php echo $v['name'] ?></option>
                              <?php endforeach ?>
                            </select>
                          </td>
						  <td>
                          <select class="form-control material" data-row-id="row_<?php echo $x; ?>" id="material_<?php echo $x; ?>" name="material[]" style="width:100%;"  onchange="getSqFt(<?php echo $x; ?>)" required>
                              <option value=""></option>
                              <?php foreach ($materials as $k => $v): ?>
                                <option value="<?php echo $v['id'] ?>" <?php if($val['material_id'] == $v['id']) { echo "selected='selected'"; } ?>><?php echo $v['name'] ?></option>
                              <?php endforeach ?>
                            </select>
                          </td>
						  <td>
                          <select class="form-control color" data-row-id="row_<?php echo $x; ?>" id="color_<?php echo $x; ?>" name="color[]" style="width:100%;"  onchange="getsqft(<?php echo $x; ?>)" required>
                              <option value=""></option>
                              <?php foreach ($colors as $k => $v): ?>
                                <option value="<?php echo $v['id'] ?>" <?php if($val['color_id'] == $v['id']) { echo "selected='selected'"; } ?>><?php echo $v['name'] ?></option>
                              <?php endforeach ?>
                            </select>
                          </td>
						  <td>
                        <select class="form-control unit_of_length" data-row-id="row_1" id="unit_of_length_1" name="unit_of_length[]" style="width:100%;" onchange="getSqFt(<?php echo $x; ?>)" required>
                            <option value="1" <?php if($val['unit_of_length'] == 1) { echo "selected='selected'"; } ?>>IN</option>
							<option value="2" <?php if($val['unit_of_length'] == 2) { echo "selected='selected'"; } ?>>MM</option>
                          </select>
                        </td>
                          <td><input type="text" name="qty[]" id="qty_<?php echo $x; ?>" class="form-control" required onchange="getSqFt(<?php echo $x; ?>)" value="<?php echo $val['qty'] ?>" autocomplete="off"></td>
                          <td>
						  <input type="text" name="width[]" id="width_<?php echo $x; ?>" class="form-control" required required onchange="getSqFt(<?php echo $x; ?>)" value="<?php echo $val['width'] ?>" autocomplete="off">
						  <input type="hidden" name="cut_width[]" id="cut_width_<?php echo $x; ?>" class="form-control" value="<?php echo $val['cut_width'] ?>" autocomplete="off">
						  </td>
						<td>
						<input type="text" name="height[]" id="height_<?php echo $x; ?>" class="form-control" required  onchange="getSqFt(<?php echo $x; ?>)" value="<?php echo $val['height'] ?>" autocomplete="off">
						<input type="hidden" name="cut_height[]" id="cut_height_<?php echo $x; ?>" class="form-control" value="<?php echo $val['cut_height'] ?>" autocomplete="off">
						</td>
						<td><input type="text" name="sqft[]" id="sqft_<?php echo $x; ?>" class="form-control" required onkeyup="getAmount(<?php echo $x; ?>)" value="<?php echo $val['sqft'] ?>" autocomplete="off"></td>

						  <td>
                            <input type="text" name="rate_value[]" id="rate_value_<?php echo $x; ?>" class="form-control" value="<?php echo $val['rate'] ?>" autocomplete="off">
                          </td>
						  <td>
                            <select type="text" name="price_per[]" id="price_per_<?php echo $x; ?>" class="form-control" required onchange="getSqFt(<?php echo $x; ?>)">
							<option value="1" <?php if($val['price_per'] == 1) { echo "selected='selected'"; } ?>>sqft</option>
							<option value="2" <?php if($val['price_per'] == 2) { echo "selected='selected'"; } ?>>each</option>
							</select>
                          </td>
                          <td>
                            <input type="text" name="amount[]" id="amount_<?php echo $x; ?>" class="form-control" disabled value="<?php echo $val['amount'] ?>" autocomplete="off">
                            <input type="hidden" name="amount_value[]" id="amount_value_<?php echo $x; ?>" class="form-control" value="<?php echo $val['amount'] ?>" autocomplete="off">
                          </td>
                          <td><button type="button" class="btn btn-default" onclick="removeRow('<?php echo $x; ?>')"><i class="fa fa-close"></i></button></td>
                       </tr>
                       <?php $x++; ?>
                     <?php endforeach; ?>
                   <?php endif; ?>
                   </tbody>
                </table>

                <br /> <br/>

                <div class="col-md-6 col-xs-12 pull pull-right">

                  <div class="form-group">
                    <label for="gross_amount" class="col-sm-5 control-label">Gross Amount</label>
                    <div class="col-sm-7">
                      <input type="text" class="form-control" id="gross_amount" name="gross_amount" disabled value="<?php echo $order_data['order']['gross_amount'] ?>" autocomplete="off">
                      <input type="hidden" class="form-control" id="gross_amount_value" name="gross_amount_value" value="<?php echo $order_data['order']['gross_amount'] ?>" autocomplete="off">
                    </div>
                  </div>
				  <?php if($is_gst_enabled == true): ?>
                  <div class="form-group">
                    <label for="gst_charge" class="col-sm-5 control-label">GST <?php echo $company_data['gst_charge_value'] ?> %</label>
                    <div class="col-sm-7">
                      <input type="text" class="form-control" id="gst_charge" name="gst_charge" disabled value="<?php echo $order_data['order']['gst_amount'] ?>" autocomplete="off">
                      <input type="hidden" class="form-control" id="gst_charge_value" name="gst_charge_value" value="<?php echo $order_data['order']['gst_amount'] ?>" autocomplete="off">
                    </div>
                  </div>
                  <?php endif; ?>
				  <?php if($is_pst_enabled == true): ?>
                  <div class="form-group">
                    <label for="pst_charge" class="col-sm-5 control-label">PST <?php echo $company_data['pst_charge_value'] ?> %</label>
                    <div class="col-sm-7">
                      <input type="text" class="form-control" id="pst_charge" name="pst_charge" disabled value="<?php echo $order_data['order']['pst_amount'] ?>" autocomplete="off">
                      <input type="hidden" class="form-control" id="pst_charge_value" name="pst_charge_value" value="<?php echo $order_data['order']['pst_amount'] ?>" autocomplete="off">
                    </div>
                  </div>
                  <?php endif; ?>
				  <div class="form-group">
                    <label for="net_amount" class="col-sm-5 control-label">Net Amount</label>
                    <div class="col-sm-7">
                      <input type="text" class="form-control" id="net_amount" name="net_amount" disabled value="<?php echo $order_data['order']['net_amount'] ?>" autocomplete="off">
                      <input type="hidden" class="form-control" id="net_amount_value" name="net_amount_value" value="<?php echo $order_data['order']['net_amount'] ?>" autocomplete="off">
                    </div>
                  </div>

                </div>
              </div>
              <!-- /.box-body -->

              <div class="box-footer">

                <!--input type="hidden" name="gst_charge_rate" value="<?php echo $company_data['gst_charge_value'] ?>" autocomplete="off"-->

                <a target="__blank" href="<?php echo base_url() . 'orders/printDiv/'.$order_data['order']['id'] ?>" class="btn btn-default" >Print</a>
                <button type="submit" class="btn btn-primary">Save Changes</button>
                <a href="<?php echo base_url('orders/') ?>" class="btn btn-warning">Back</a>
              </div>
            </form>
          <!-- /.box-body -->
        </div>
        <!-- /.box -->
      </div>
      <!-- col-md-12 -->
    </div>
    <!-- /.row -->
    

  </section>
  <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<script type="text/javascript">
  var base_url = "<?php echo base_url(); ?>";

  // function printOrder(id)
  // {
  //   if(id) {
  //     $.ajax({
  //       url: base_url + 'orders/printDiv/' + id,
  //       type: 'post',
  //       success:function(response) {
  //         var mywindow = window.open('', 'new div', 'height=400,width=600');
  //         // mywindow.document.write('<html><head><title></title>');
  //         // mywindow.document.write('<link rel="stylesheet" href="<?php //echo base_url('assets/bower_components/bootstrap/dist/css/bootstrap.min.css') ?>" type="text/css" />');
  //         // mywindow.document.write('</head><body >');
  //         mywindow.document.write(response);
  //         // mywindow.document.write('</body></html>');

  //         mywindow.print();
  //         mywindow.close();

  //         return true;
  //       }
  //     });
  //   }
  // }
  
  $(document).ready(function() {
    $(".select_group").select2();
    // $("#description").wysihtml5();

    $("#mainOrdersNav").addClass('active');
    $("#addOrderNav").addClass('active');
    
    var btnCust = '<button type="button" class="btn btn-secondary" title="Add picture tags" ' + 
        'onclick="alert(\'Call your custom code here.\')">' +
        '<i class="glyphicon glyphicon-tag"></i>' +
        '</button>'; 
  
    // Add new row in the table 
    $("#add_row").unbind('click').bind('click', function() {
      var table = $("#product_info_table");
      var count_table_tbody_tr = $("#product_info_table tbody tr").length;
      var row_id = count_table_tbody_tr + 1;

      $.ajax({
          url: base_url + '/orders/getTableProductRow/',
          type: 'post',
          dataType: 'json',
          success:function(response) {
            
              // console.log(reponse.x);
               var html = '<tr id="row_'+row_id+'">'+
                   '<td>'+ 
                    '<select class="form-control" data-row-id="'+row_id+'" id="product_'+row_id+'" name="product[]" style="width:100%;" onchange="getProductData('+row_id+')">'+
                        '<option value=""></option>';
                        $.each(response, function(index, value) {
                          html += '<option value="'+value.id+'">'+value.name+'</option>';             
                        });
                        
                      html += '</select>'+
                    '</td>'+
					'<td>'+ 
                    '<select class="form-control" data-row-id="'+row_id+'" id="material_'+row_id+'" name="material[]" style="width:100%;" onchange="getProductData('+row_id+')">'+
                        '<option value=""></option>';
                        '<?php foreach ($materials as $k => $v): ?>';
                              html += '<option value="<?php echo $v['id'] ?>"><?php echo $v['name'] ?></option>';
                            '<?php endforeach ?>';
                      html += '</select>'+
                    '</td>'+
					'<td>'+ 
                    '<select class="form-control" data-row-id="'+row_id+'" id="color_'+row_id+'" name="color[]" style="width:100%;" onchange="getProductData('+row_id+')">'+
                        '<option value=""></option>';
                        '<?php foreach ($colors as $k => $v): ?>';
                              html += '<option value="<?php echo $v['id'] ?>"><?php echo $v['name'] ?></option>';
                            '<?php endforeach ?>';
                      html += '</select>'+
                    '</td>'+
					'<td>'+ 
                    '<select class="form-control uom" data-row-id="'+row_id+'" id="uom_'+row_id+'" name="uom[]" style="width:100%;" onchange="getSqFt('+row_id+')">'+
						'<option value="1">IN</option>';
						html += '<option value="2">MM</option>';
                      html += '</select>'+
                    '</td>'+ 
                    '<td><input type="number" name="qty[]" id="qty_'+row_id+'" class="form-control" onchange="getSqFt('+row_id+')"></td>'+
					'<td>'+
					'<input type="text" name="width[]" id="width_'+row_id+'" class="form-control" required onchange="getSqFt('+row_id+')">'+
					'<input type="hidden" name="cut_width[]" id="cut_width_'+row_id+'" class="form-control">'+
					'</td>'+
					'<td>'+
					'<input type="text" name="height[]" id="height_'+row_id+'" class="form-control" required onchange="getSqFt('+row_id+')">'+
					'<input type="hidden" name="cut_height[]" id="cut_height_'+row_id+'" class="form-control">'+
					'</td>'+
					'<td><input type="text" name="sqft[]" id="sqft_'+row_id+'" class="form-control" onchange="getAmount('+row_id+')"></td>'+
                    '<td><input type="text" name="rate_value[]" id="rate_value_'+row_id+'" class="form-control"></td>'+
                    '<td>'+ 
                    '<select class="form-control" data-row-id="'+row_id+'" id="price_per_'+row_id+'" name="price_per[]" style="width:100%;"onchange="getAmount('+row_id+')">'+
                        '<option value="1">sqft</option>';
						html += '<option value="2">each</option>';
                      html += '</select>'+
                    '</td>'+ 
					'<td><input type="text" name="amount[]" id="amount_'+row_id+'" class="form-control" disabled><input type="hidden" name="amount_value[]" id="amount_value_'+row_id+'" class="form-control"></td>'+
                    '<td><button type="button" class="btn btn-default" onclick="removeRow(\''+row_id+'\')"><i class="fa fa-close"></i></button></td>'+
                    '</tr>';

                if(count_table_tbody_tr >= 1) {
                $("#product_info_table tbody tr:last").after(html);  
              }
              else {
                $("#product_info_table tbody").html(html);
              }

              $(".product").select2();

          }
        });

      return false;
    });

  }); // /document

  function getTotal(row) {
    if(row) {
      var total = Number($("#rate_value_"+row).val()) * Number($("#qty_"+row).val());
      total = total.toFixed(2);
      $("#amount_"+row).val(total);
      $("#amount_value_"+row).val(total);
      
      subAmount();

    } else {
      alert('no row !! please refresh the page');
    }
  }
  
function getSqFt(row = null) 
  {
    if(row) {
		var uom = Number($("#uom_"+row).val());
		var sqft = Number((toDeci($("#width_"+row).val(),uom)) * Number(toDeci($("#height_"+row).val(),uom)))/144;
		if (sqft < 1.5)
		{
			sqft = 1.5;
			sqft = sqft.toFixed(2) * Number($("#qty_"+row).val());
			$("#sqft_"+row).val(sqft);
		}
		else 
		{
		sqft = sqft.toFixed(2) * Number($("#qty_"+row).val());
		$("#sqft_"+row).val(sqft);
		}
		var color_id = $("#color_"+row).val();   
		$.ajax({
        url: base_url + 'orders/getColorValueById',
        type: 'post',
        data: {color_id : color_id},
        dataType: 'json',
        success:function(response) {
          // setting the cut value into the cut input field
			$("#cut_width_"+row).val((((Number((toDeci($("#width_"+row).val(),uom)))*25.4)).toFixed(2))-(response.thickness * 2));
			$("#cut_height_"+row).val((((Number((toDeci($("#height_"+row).val(),uom)))*25.4)).toFixed(2))-(response.thickness * 2));

        } // /success
      }); // /ajax function to fetch the color data 

    } else {
      alert('no row !! please refresh the page');
    }
	getAmount(row);
  }
  
  function toDeci(fraction, u) {
        fraction = fraction.toString();
        var result, wholeNum = 0, frac, deci = 0;
        if (fraction.search('/') >= 0) {
            if (fraction.search(' ') >= 0) {
                wholeNum = fraction.split(' ');
                frac = wholeNum[1];
                wholeNum = parseInt(wholeNum, 10);
            } else {
                frac = fraction;
            }
            if (fraction.search('/') >= 0) {
                frac = frac.split('/');
                deci = parseInt(frac[0], 10) / parseInt(frac[1], 10);
            }
            result = wholeNum + deci;
        } 
		else if (u == 2)
		{
			result = fraction / 25.4;
		}
		else
		{
			result = fraction
		}
        return result;
    }

  // get the product information from the server
  /* function getProductDataOLD(row_id)
  {
    var product_id = $("#product_"+row_id).val();    
    if(product_id == "") {
      $("#rate_"+row_id).val("");
      $("#rate_value_"+row_id).val("");

      $("#qty_"+row_id).val("");           

      $("#amount_"+row_id).val("");
      $("#amount_value_"+row_id).val("");

    } else {
      $.ajax({
        url: base_url + 'orders/getProductValueById',
        type: 'post',
        data: {product_id : product_id},
        dataType: 'json',
        success:function(response) {
          // setting the rate value into the rate input field
          
          $("#rate_"+row_id).val(response.price);
          $("#rate_value_"+row_id).val(response.price);

          $("#qty_"+row_id).val(1);
          $("#qty_value_"+row_id).val(1);

          var total = Number(response.price) * 1;
          total = total.toFixed(2);
		  var total = Number($("#sqft_"+row_id).val()) * Number($("#rate_value_"+row_id).val());
		  total = total.toFixed(2);
          $("#amount_"+row_id).val(total);
          $("#amount_value_"+row_id).val(total);
          
        } // /success
      }); // /ajax function to fetch the product data 
    }
  } */
  
  // get the product information from the server
  function getAmount(row_id)
  {
	  if(row_id) {
		var per = Number($("#price_per_"+row_id).val());
		if(per==1)
			{
				var total = Number($("#rate_value_"+row_id).val()) * Number($("#sqft_"+row_id).val());
				
			} else
			{
				var total = Number($("#rate_value_"+row_id).val()) * Number($("#qty_"+row_id).val());
			}
		  
		  total = total.toFixed(2);
          $("#amount_"+row_id).val(total);
          $("#amount_value_"+row_id).val(total);
		  
		  subAmount();
          
   }
   else {
      alert('no row !! please refresh the page');
    }
  }
  
  // get the product material & color information from the server
  function getProductData(row_id)
  {
    var product_price;
	var material_price;
	var color_price;
	var total;
	
	var product_id = $("#product_"+row_id).val(); 
	var material_id = $("#material_"+row_id).val();
	var color_id = $("#color_"+row_id).val();
    if(product_id == "") {

    } else {
      $.ajax({
        url: base_url + 'orders/getProductValueById',
        type: 'post',
		async: false,
        data: {product_id : product_id},
        dataType: 'json',
        success:function(response) {
          // setting the rate value into the rate input field

			product_price = Number(response.price);
			product_price = product_price.toFixed(2);


        } // /success
      }); // /ajax function to fetch the product data 
    }
	if(material_id == "") {

    } else {
      $.ajax({
        url: base_url + 'orders/getMaterialValueById',
        type: 'post',
		async: false,
        data: {material_id : material_id},
        dataType: 'json',
        success:function(response) {
          // setting the rate value into the rate input field

			material_price = Number(response.price);
			material_price = material_price.toFixed(2);

        } // /success
      }); // /ajax function to fetch the product data 
    }
	
	if(color_id == "") {

    } else {
      $.ajax({
        url: base_url + 'orders/getColorValueById',
        type: 'post',
		async: false,
        data: {color_id : color_id},
        dataType: 'json',
        success:function(response) {
          // setting the rate value into the rate input field

			color_price = Number(response.price);
			color_price = color_price.toFixed(2);

        } // /success
      }); // /ajax function to fetch the product data 
    }
	
			
			total = Number(product_price) + Number(material_price) + Number(color_price);
			total = total.toFixed(2);
			$("#rate_"+row_id).val(total);
			$("#rate_value_"+row_id).val(total);
			
			
			getAmount(row_id);
	}
  
  
  // get the customer information from the server
  function getCustomerData()
  {
	  var customer_id = $("#customer_id").val(); 
	  $.ajax({
        url: base_url + 'orders/getCustomerDataById',
        type: 'post',
        data: {customer_id : customer_id},
        dataType: 'json',
        success:function(response) {
		  document.getElementById("payment_terms_id").value = response.payment_terms_id;
		  document.getElementById("sales_tax_id").value = response.tax_code_id;
        }
      });
  }
  
 // calculate the total QTY of the order
   function Qty()
   {
    
    var tableProductLength = $("#product_info_table tbody tr").length;
    var totalQty = 0;
    for(x = 0; x < tableProductLength; x++) 
	{
      var tr = $("#product_info_table tbody tr")[x];
      var count = $(tr).attr('id');
      count = count.substring(4);

      totalQty = Number(totalQty) + Number($("#qty_"+count).val());
     // /for
	}

    // sub total
    $("#total_quantity").val(totalQty);
    $("#total_quantity_value").val(totalQty);
	}
	
	// calculate the total Sqft of the order
   function Sqft()
   {
    
    var tableProductLength = $("#product_info_table tbody tr").length;
    var totalSqft = 0;
    for(x = 0; x < tableProductLength; x++) 
	{
      var tr = $("#product_info_table tbody tr")[x];
      var count = $(tr).attr('id');
      count = count.substring(4);

      totalSqft = Number(totalSqft) + Number($("#sqft_"+count).val());
     // /for
	}
     totalSqft = totalSqft.toFixed(2);

    // sub total
    $("#total_sqft").val(totalSqft);
    $("#total_sqft_value").val(totalSqft);
	}


  // calculate the total amount of the order
   function subAmount() {
    var gst_charge = <?php echo ($company_data['gst_charge_value'] > 0) ? $company_data['gst_charge_value']:0; ?>;
    var pst_charge = <?php echo ($company_data['pst_charge_value'] > 0) ? $company_data['pst_charge_value']:0; ?>;

    var tableProductLength = $("#product_info_table tbody tr").length;
    var totalSubAmount = 0;
    for(x = 0; x < tableProductLength; x++) {
      var tr = $("#product_info_table tbody tr")[x];
      var count = $(tr).attr('id');
      count = count.substring(4);

      totalSubAmount = Number(totalSubAmount) + Number($("#amount_"+count).val());
    } // /for

    totalSubAmount = totalSubAmount.toFixed(2);

    // sub total
    $("#gross_amount").val(totalSubAmount);
    $("#gross_amount_value").val(totalSubAmount);

    // gst
    var gst = (Number($("#gross_amount_value").val())/100) * gst_charge;
    gst = gst.toFixed(2);
    $("#gst_charge").val(gst);
    $("#gst_charge_value").val(gst);
	
	
	
	// pst
	var tax_id = $("#sales_tax_id").val();
	if(tax_id==3){
    var pst = (Number($("#gross_amount_value").val())/100) * pst_charge;
    pst = pst.toFixed(2);
    $("#pst_charge").val(pst);
    $("#pst_charge_value").val(pst);
	}else{
	$("#pst_charge").val(0);
    $("#pst_charge_value").val(0);
	
	}
	
	totalAmount()
	Qty()
    Sqft()
	}

    // service
    /* var service = (Number($("#gross_amount").val())/100) * service_charge;
    service = service.toFixed(2);
    $("#service_charge").val(service);
    $("#service_charge_value").val(service); */
    
    // total amount
	
	function totalAmount()
  {
	  
		var tax_id = $("#sales_tax_id").val(); 
		var gst_value = $("#gst_charge_value").val(); 
		var pst_value = $("#pst_charge_value").val(); 
		var gross_value = $("#gross_amount_value").val(); 
		
		//gst = 2, pst = 3
		if(tax_id==2){
			var totalAmount = (Number(gross_value) + Number(gst_value));
		}else{
			var totalAmount = (Number(gross_value) + Number(gst_value) + Number(pst_value));
		}
		 
          
   
  
    //var totalAmount = (Number(totalSubAmount) + Number(gst) + Number(pst));
    totalAmount = totalAmount.toFixed(2);
    $("#net_amount").val(totalAmount);
    $("#net_amount_value").val(totalAmount);
  }
    /* var discount = $("#discount").val();
    if(discount) {
      var grandTotal = Number(totalAmount) - Number(discount);
      grandTotal = grandTotal.toFixed(2);
      $("#net_amount").val(grandTotal);
      $("#net_amount_value").val(grandTotal);
    } else {
      $("#net_amount").val(totalAmount);
      $("#net_amount_value").val(totalAmount);
      
    } */ // /else discount 

   // /sub total amount */

  function removeRow(tr_id)
  {
    $("#product_info_table tbody tr#row_"+tr_id).remove();
    //subAmount();
  }
</script>