<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Orders extends Admin_Controller 
{
	public function __construct()
	{
		parent::__construct();

		$this->not_logged_in();

		$this->data['page_title'] = 'Orders';

		$this->load->model('model_orders');
		$this->load->model('model_products');
		$this->load->model('model_materials');
		$this->load->model('model_colors');
		$this->load->model('model_company');
		$this->load->model('model_customers');
		$this->load->model('model_category');
		$this->load->model('model_terms');
		$this->load->model('model_tax');
		$this->load->model('model_users');
	}

	/* 
	* It only redirects to the manage order page
	*/
	public function index()
	{
		if(!in_array('viewOrder', $this->permission)) {
            redirect('dashboard', 'refresh');
        }

		$this->data['page_title'] = 'Manage Orders';
		$this->render_template('orders/index', $this->data);		
	}

	/*
	* Fetches the orders data from the orders table 
	* this function is called from the datatable ajax function
	*/
	public function fetchOrdersData()
	{
		$result = array('data' => array());

		$data = $this->model_orders->getOrdersData();

		foreach ($data as $key => $value) {

			$count_total_item = $this->model_orders->countOrderItem($value['id']);
			//$date = date('d-m-Y', $value['order_date']);
			//$time = date('h:i a', $value['order_date']);

			//$order_date = $date . ' ' . $time;
			$category_data = $this->model_category->getCategoryData($value['category_id']);
			$customer_data = $this->model_customers->getCustomerData($value['customer_id']);
			// button
			$buttons = '';

			if(in_array('viewOrder', $this->permission)) {
				$buttons .= '<a target="__blank" href="'.base_url('orders/printDiv/'.$value['id']).'" class="btn btn-default"><i class="fa fa-print"></i></a>';
			}
			
			if(in_array('viewOrder', $this->permission)) {
				$buttons .= '<a target="__blank" href="'.base_url('orders/csvDiv/'.$value['id']).'" class="btn btn-default"><i class="fa fa-file"></i></a>';
			}
			if(in_array('viewOrder', $this->permission)) {
				$buttons .= '<a target="__blank" href="'.base_url('orders/csvDiv0/'.$value['id']).'" class="btn btn-default"><i class="fa fa-file-archive-o"></i></a>';
			}
			
			if(in_array('viewOrder', $this->permission)) {
				$buttons .= '<a target="__blank" href="'.base_url('orders/csvDiv1/'.$value['id']).'" class="btn btn-default"><i class="fa fa-database"></i></a>';
			}


			if(in_array('updateOrder', $this->permission)) {
				$buttons .= ' <a href="'.base_url('orders/update/'.$value['id']).'" class="btn btn-default"><i class="fa fa-pencil"></i></a>';
			}

			if(in_array('deleteOrder', $this->permission)) {
				$buttons .= ' <button type="button" class="btn btn-default" onclick="removeFunc('.$value['id'].')" data-toggle="modal" data-target="#removeModal"><i class="fa fa-trash"></i></button>';
			}

			if($value['status'] == 1) {
				$status = '<span class="label label-success">In Process</span>';	
			}
			else {
				$status = '<span class="label label-warning">Pending</span>';
			}

			$result['data'][$key] = array(
				$value['order_no'],
				$category_data['name'],
				$customer_data['customer_name'],
				$value['customer_ref_number'],
				$value['order_date'],
				$value['delivery_date'],
				//$count_total_item,
				$value['net_amount'],
				$status,
				$buttons
			);
		} // /foreach

		echo json_encode($result);
	}

	/*
	* If the validation is not valid, then it redirects to the create page.
	* If the validation for each input field is valid then it inserts the data into the database 
	* and it stores the operation message into the session flashdata and display on the manage group page
	*/
	public function create()
	{
		if(!in_array('createOrder', $this->permission)) {
            redirect('dashboard', 'refresh');
        }

		$this->data['page_title'] = 'Add Order';

		$this->form_validation->set_rules('product[]', 'Product name', 'trim|required');
		
	
        if ($this->form_validation->run() == TRUE) {        	
        	
        	$order_id = $this->model_orders->create();
        	
        	if($order_id) {
        		$this->session->set_flashdata('success', 'Successfully created');
        		redirect('orders/update/'.$order_id, 'refresh');
        	}
        	else {
        		$this->session->set_flashdata('errors', 'Error occurred!!');
        		redirect('orders/create/', 'refresh');
        	}
        }
        else {
            // false case
        	$company = $this->model_company->getCompanyData(1);
        	$this->data['company_data'] = $company;
        	$this->data['is_gst_enabled'] = ($company['gst_charge_value'] > 0) ? true : false;
        	$this->data['is_pst_enabled'] = ($company['pst_charge_value'] > 0) ? true : false;
        	$this->data['products'] = $this->model_products->getActiveProductData();
			$this->data['materials'] = $this->model_materials->getActiveMaterialData();
			$this->data['colors'] = $this->model_colors->getActiveColorData();
			$this->data['customers'] = $this->model_customers->getActiveCustomerData();
			$this->data['category'] = $this->model_category->getCategoryData();
			$this->data['terms'] = $this->model_terms->getActiveTerms();
			$this->data['tax'] = $this->model_tax->getActiveTax();
            $this->render_template('orders/create', $this->data);
        }	
	}

	/*
	* It gets the product id passed from the ajax method.
	* It checks retrieves the particular product data from the product id 
	* and return the data into the json format.
	*/
	public function getProductValueById()
	{
		$product_id = $this->input->post('product_id');
		if($product_id) {
			$product_data = $this->model_products->getProductData($product_id);
			echo json_encode($product_data);
		}
	}
	
	public function getColorValueById()
	{
		$color_id = $this->input->post('color_id');
		if($color_id) {
			$color_data = $this->model_colors->getColorData($color_id);
			echo json_encode($color_data);
		}
	}
	
	public function getMaterialValueById()
	{
		$material_id = $this->input->post('material_id');
		if($material_id) {
			$material_data = $this->model_materials->getMaterialData($material_id);
			echo json_encode($material_data);
		}
	}
	
	public function getCustomerDataById()
	{
		$customer_id = $this->input->post('customer_id');
		if($customer_id) {
			$customer_data = $this->model_customers->getCustomerData($customer_id);
			echo json_encode($customer_data);
		}
	}

	/*
	* It gets the all the active product inforamtion from the product table 
	* This function is used in the order page, for the product selection in the table
	* The response is return on the json format.
	*/
	public function getTableProductRow()
	{
		$products = $this->model_products->getActiveProductData();
		echo json_encode($products);
	}
	
	public function getTableCustomerRow()
	{
		$customers = $this->customers->getActiveCustomerData();
		echo json_encode($customers);
	}

	/*
	* If the validation is not valid, then it redirects to the edit orders page 
	* If the validation is successfully then it updates the data into the database 
	* and it stores the operation message into the session flashdata and display on the manage group page
	*/
	public function update($id)
	{
		if(!in_array('updateOrder', $this->permission)) {
            redirect('dashboard', 'refresh');
        }

		if(!$id) {
			redirect('dashboard', 'refresh');
		}

		$this->data['page_title'] = 'Update Order';

		$this->form_validation->set_rules('product[]', 'Product name', 'trim|required');
		
	
        if ($this->form_validation->run() == TRUE) {        	
        	
        	$update = $this->model_orders->update($id);
        	
        	if($update == true) {
        		$this->session->set_flashdata('success', 'Successfully updated');
        		redirect('orders/update/'.$id, 'refresh');
        	}
        	else {
        		$this->session->set_flashdata('errors', 'Error occurred!!');
        		redirect('orders/update/'.$id, 'refresh');
        	}
        }
        else {
            // false case
        	$company = $this->model_company->getCompanyData(1);
        	$this->data['company_data'] = $company;
        	$this->data['is_gst_enabled'] = ($company['gst_charge_value'] > 0) ? true : false;
        	$this->data['is_pst_enabled'] = ($company['pst_charge_value'] > 0) ? true : false;

        	$result = array();
        	$orders_data = $this->model_orders->getOrdersData($id);
			$this->data['orderdata'] = $orders_data;
			
    		$result['order'] = $orders_data;
    		$orders_item = $this->model_orders->getOrdersItemData($orders_data['id']);

    		foreach($orders_item as $k => $v) {
    			$result['order_item'][] = $v;
    		}

    		$this->data['order_data'] = $result;

			$this->data['category'] = $this->model_category->getCategoryData();
			$this->data['customers'] = $this->model_customers->getActiveCustomerData();
        	$this->data['products'] = $this->model_products->getActiveProductData();
			$this->data['materials'] = $this->model_materials->getActiveMaterialData();
			$this->data['colors'] = $this->model_colors->getActiveColorData();
			$this->data['terms'] = $this->model_terms->getActiveTerms();
			$this->data['tax'] = $this->model_tax->getActiveTax();
			$this->data['user_data'] = $this->model_users->getUserData($orders_data['user_id']);

            $this->render_template('orders/edit', $this->data);
        }
	}

	/*
	* It removes the data from the database
	* and it returns the response into the json format
	*/
	public function remove()
	{
		if(!in_array('deleteOrder', $this->permission)) {
            redirect('dashboard', 'refresh');
        }

		$order_id = $this->input->post('order_id');

        $response = array();
        if($order_id) {
            $delete = $this->model_orders->remove($order_id);
            if($delete == true) {
                $response['success'] = true;
                $response['messages'] = "Successfully removed"; 
            }
            else {
                $response['success'] = false;
                $response['messages'] = "Error in the database while removing the product information";
            }
        }
        else {
            $response['success'] = false;
            $response['messages'] = "Refersh the page again!!";
        }

        echo json_encode($response); 
	}
	//cnc
	public function csvDiv($id)
	{
		$result = array();
        	$orders_data = $this->model_orders->getOrdersData($id);
			$filename = "{$orders_data['order_no']}.csv";
			$fp = fopen('php://output', 'w');

			header('Content-type: application/csv');
			header('Content-Disposition: attachment; filename='.$filename);
    		$orders_item = $this->model_orders->getOrdersCncData($orders_data['id']);

    		foreach($orders_item as $k => $v) {
    			fputcsv($fp, $v);
    		}
		exit;
	}
	//cncbase
	public function csvDiv0($id)
	{
		$result = array();
        	$orders_data = $this->model_orders->getOrdersData($id);
			$filename = "{$orders_data['order_no']}.csv";
			$fp = fopen('php://output', 'w');

			header('Content-type: application/csv');
			header('Content-Disposition: attachment; filename='.$filename);
    		$orders_item = $this->model_orders->getOrdersCncbaseData($orders_data['id']);

    		foreach($orders_item as $k => $v) {
    			fputcsv($fp, $v);
    		}
		exit;
	}
	//quickbook
	public function csvDiv1($id)
	{
		$result = array();
        	$orders_data = $this->model_orders->getOrdersData($id);
			$filename = "{$orders_data['order_no']}.csv";
			$fp = fopen('php://output', 'w');

			header('Content-type: application/csv');
			header('Content-Disposition: attachment; filename='.$filename);
    		$orders_item = $this->model_orders->getOrdersQBData($orders_data['id']);

    		foreach($orders_item as $k => $v) {
    			fputcsv($fp, $v);
    		}
		exit;
	}
    
    
	
	/* It gets the product id and fetch the order data. 
	*The order print logic is done here */
	
	public function printDiv($id)
	{
		if(!in_array('viewOrder', $this->permission)) {
            redirect('dashboard', 'refresh');
        }
		if($id) {
			$order_data = $this->model_orders->getOrdersData($id);
			$orders_items = $this->model_orders->getOrdersItemDataReport($id);
			$company_info = $this->model_company->getCompanyData(1);
			$customer_info = $this->model_customers->getCustomerData(1);
			
			

			$order_date = $order_data['order_date'];
			$status = ($order_data['status'] == 1) ? "Paid" : "Unpaid";

			$html = '<!-- Main content -->
			<!DOCTYPE html>
			<html>
			<head>
			<script language="JavaScript">
             function mdy(todaysdate)
			 {
           
             return todaysdate.getMonth()+1+"/"+todaysdate.getDate()+"/"+todaysdate.getFullYear()
              }
              </script>
			  <meta charset="utf-8">
			  <meta http-equiv="X-UA-Compatible" content="IE=edge">
			  <title>AdminLTE 2 | Invoice</title>
			  <!-- Tell the browser to be responsive to screen width -->
			  <meta content="width=device-width, initial-scale=1, maximum-scale=2, user-scalable=no" name="viewport">
			  <!-- Bootstrap 3.3.7 -->
			  <link rel="stylesheet" href="'.base_url('assets/bower_components/bootstrap/dist/css/bootstrap.min.css').'">
			  <!-- Font Awesome -->
			  <link rel="stylesheet" href="'.base_url('assets/bower_components/font-awesome/css/font-awesome.min.css').'">
			  <link rel="stylesheet" href="'.base_url('assets/dist/css/AdminLTE.min.css').'">
			</head>
			<body onload="window.print();">
			
			<div class="wrapper">
			  <section class="invoice">
	
			    <div class="row">
			      <div class="col-xs-4" style="float:right" >
				  <b><font size="5">Work Order</b></font>
				  </div></div>
			    <!-- title row -->
				 <h2 class="page-header">
			    <div class="row">
			      <div class="col-xs-12" style="float:left;">
				    <b> '.$company_info['company_name'].'</b></br>
					<small class <br>'.$company_info['address'].'</br>
					 '.$company_info['country'].'</br>
					 Ph:'.$company_info['phone'].'</.small>
				  			     
           			 <div class="col-xs-4" style="float:right" width=50%>
			        
					
					<b>
		            <script language="JavaScript">
                    sampleDate1=new Date()
                   document.write ( "Date :  "  + mdy(sampleDate1))
                     </script></b>
					 
			    
			      <!-- /.col -->
			    </div>
			    <!-- /.row -->	 
			          
		       
			      </div>
			      <!-- /.col -->
				   </h2>
			   
				
				
				
				
				
				
		         <!--PO-->
				<div class="row">
			      <div class= " col-xs-10 table-responsive pull pull-left">
			        <table class="table table-striped"  >
			        
					<thead> <td><b>order_no: &nbsp;  </b> '.$order_data['order_no'].'</br></td> </br>
					    <td><b>Quantity: </b>    &nbsp  &nbsp '.$order_data['total_quantity'].'</td>
			            <td><b>Customer P.O. no. :</b>    &nbsp  &nbsp '.$order_data['customer_ref_number'].' </td> 
						<td><b>Ordered date: </b>    &nbsp  &nbsp '.$order_data['order_date'].'</td>
						</table>
						
						</div></div>
			         
				
			    <!-- Main Table  -->
			    <div class="row">
			      <div class="col-xs-12">
				  <style>
                          table {
                           border: 1px solid black;
                               border-collapse: collapse;
                                }
                    </style>
			        <table  style="width:83%"  border="1|0" >
					   
			            <th style="text-align:center">Product</th>
						<th style="text-align:center">Qty</th>
						<th style="text-align:center">Width</th>
						<th style="text-align:center">Height</th>
					   <tbody>'; 
					   $lastproduct = "";
					   $product = "";
			          foreach ($orders_items as $k => $v) {

			          	$product_data = $this->model_products->getProductData($v['product_id']); 
						$color_data = $this->model_colors->getColorData($v['color_id']); 
						$material_data = $this->model_materials->getMaterialData($v['material_id']); 

						$currentproduct = $v['product_id']."".$v['color_id']."".$v['material_id'];
						
						
						if ($currentproduct != $lastproduct) {
						$product = $product_data['name']." || ".$material_data['name']." || ".$color_data['name'];
						} else{
						$product = "";
						}
						
						
			          	
			          	$html .= '<tr>
				            <td align="center">'.$product.'</td>
							<td align="center">'.$v['qty'].'</td>
							<td align="center">'.$v['width'].'</td>
							<td align="center">'.$v['height'].'</td>  
			          	</tr>';
						$lastproduct = $v['product_id']."".$v['color_id']."".$v['material_id'];
			          }
			          $html .= '
			          </tbody>
			        </table>
					</div>
					
					
			   
			  </section>
			  <!-- /.content -->
			</div>
		</body>
	</html>';

			  echo $html;
		}
	}

}