<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Terms extends Admin_Controller 
{
	public function __construct()
	{
		parent::__construct();

		$this->not_logged_in();

		$this->data['page_title'] = 'Terms';

		$this->load->model('model_terms');
	}

	/* 
	* It only redirects to the manage product page and
	*/
	public function index()
	{
		if(!in_array('viewTerm', $this->permission)) {
			redirect('dashboard', 'refresh');
		}

		$result = $this->model_terms->getTermData();

		$this->data['results'] = $result;

		$this->render_template('terms/index', $this->data);
	}

	/*
	* Fetches the term data from the term table 
	* this function is called from the datatable ajax function
	*/
	public function fetchTermData()
	{
		$result = array('data' => array());

		$data = $this->model_terms->getTermData();
		foreach ($data as $key => $value) {

			// button
			$buttons = '';

			if(in_array('viewTerm', $this->permission)) {
				$buttons .= '<button type="button" class="btn btn-default" onclick="editTerm('.$value['id'].')" data-toggle="modal" data-target="#editTermModal"><i class="fa fa-pencil"></i></button>';	
			}
			
			if(in_array('deleteTerm', $this->permission)) {
				$buttons .= ' <button type="button" class="btn btn-default" onclick="removeTerm('.$value['id'].')" data-toggle="modal" data-target="#removeTermModal"><i class="fa fa-trash"></i></button>
				';
			}				

			$status = ($value['active'] == 1) ? '<span class="label label-success">Active</span>' : '<span class="label label-warning">Inactive</span>';

			$result['data'][$key] = array(
				$value['name'],
				$status,
				$buttons
			);
		} // /foreach

		echo json_encode($result);
	}

	/*
	* It checks if it gets the term id and retreives
	* the term information from the term model and 
	* returns the data into json format. 
	* This function is invoked from the view page.
	*/
	public function fetchTermDataById($id)
	{
		if($id) {
			$data = $this->model_terms->getTermData($id);
			echo json_encode($data);
		}

		return false;
	}

	/*
	* Its checks the term form validation 
	* and if the validation is successfully then it inserts the data into the database 
	* and returns the json format operation messages
	*/
	public function create()
	{

		if(!in_array('createTerm', $this->permission)) {
			redirect('dashboard', 'refresh');
		}

		$response = array();

		$this->form_validation->set_rules('term_name', 'Term name', 'trim|required');
		$this->form_validation->set_rules('active', 'Active', 'trim|required');

		$this->form_validation->set_error_delimiters('<p class="text-danger">','</p>');

        if ($this->form_validation->run() == TRUE) {
        	$data = array(
        		'name' => $this->input->post('term_name'),
        		'active' => $this->input->post('active'),	
        	);

        	$create = $this->model_terms->create($data);
        	if($create == true) {
        		$response['success'] = true;
        		$response['messages'] = 'Succesfully created';
        	}
        	else {
        		$response['success'] = false;
        		$response['messages'] = 'Error in the database while creating the term information';			
        	}
        }
        else {
        	$response['success'] = false;
        	foreach ($_POST as $key => $value) {
        		$response['messages'][$key] = form_error($key);
        	}
        }

        echo json_encode($response);

	}

	/*
	* Its checks the term form validation 
	* and if the validation is successfully then it updates the data into the database 
	* and returns the json format operation messages
	*/
	public function update($id)
	{
		if(!in_array('updateTerm', $this->permission)) {
			redirect('dashboard', 'refresh');
		}

		$response = array();

		if($id) {
			$this->form_validation->set_rules('edit_term_name', 'Term name', 'trim|required');
			$this->form_validation->set_rules('edit_active', 'Active', 'trim|required');

			$this->form_validation->set_error_delimiters('<p class="text-danger">','</p>');

	        if ($this->form_validation->run() == TRUE) {
	        	$data = array(
	        		'name' => $this->input->post('edit_term_name'),
	        		'active' => $this->input->post('edit_active'),	
	        	);

	        	$update = $this->model_terms->update($data, $id);
	        	if($update == true) {
	        		$response['success'] = true;
	        		$response['messages'] = 'Succesfully updated';
	        	}
	        	else {
	        		$response['success'] = false;
	        		$response['messages'] = 'Error in the database while updated the term information';			
	        	}
	        }
	        else {
	        	$response['success'] = false;
	        	foreach ($_POST as $key => $value) {
	        		$response['messages'][$key] = form_error($key);
	        	}
	        }
		}
		else {
			$response['success'] = false;
    		$response['messages'] = 'Error please refresh the page again!!';
		}

		echo json_encode($response);
	}

	/*
	* It removes the term information from the database 
	* and returns the json format operation messages
	*/
	public function remove()
	{
		if(!in_array('deleteTerm', $this->permission)) {
			redirect('dashboard', 'refresh');
		}
		
		$term_id = $this->input->post('term_id');
		$response = array();
		if($term_id) {
			$delete = $this->model_terms->remove($term_id);

			if($delete == true) {
				$response['success'] = true;
				$response['messages'] = "Successfully removed";	
			}
			else {
				$response['success'] = false;
				$response['messages'] = "Error in the database while removing the term information";
			}
		}
		else {
			$response['success'] = false;
			$response['messages'] = "Refersh the page again!!";
		}

		echo json_encode($response);
	}

}