<?php 

class Model_materials extends CI_Model
{
	public function __construct()
	{
		parent::__construct();
	}

	/* get the brand data */
	public function getMaterialData($id = null)
	{
		if($id) {
			$sql = "SELECT * FROM materials where id = ?";
			$query = $this->db->query($sql, array($id));
			return $query->row_array();
		}

		$sql = "SELECT * FROM materials ORDER BY id DESC";
		$query = $this->db->query($sql);
		return $query->result_array();
	}

	public function getActiveMaterialData()
	{
		$sql = "SELECT * FROM materials";
		$query = $this->db->query($sql, array(1));
		return $query->result_array();
	}

	public function create($data)
	{
		if($data) {
			$insert = $this->db->insert('materials', $data);
			return ($insert == true) ? true : false;
		}
	}

	public function update($data, $id)
	{
		if($data && $id) {
			$this->db->where('id', $id);
			$update = $this->db->update('materials', $data);
			return ($update == true) ? true : false;
		}
	}

	public function remove($id)
	{
		if($id) {
			$this->db->where('id', $id);
			$delete = $this->db->delete('materials');
			return ($delete == true) ? true : false;
		}
	}

	public function countTotalMaterials()
	{
		$sql = "SELECT * FROM materials";
		$query = $this->db->query($sql);
		return $query->num_rows();
	}

}