<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Customers extends Admin_Controller 
{
	public function __construct()
	{
		parent::__construct();

		$this->not_logged_in();

		$this->data['page_title'] = 'Customers';

		$this->load->model('model_customers');
	}

    /* 
    * It only redirects to the manage customer page
    */
	public function index()
	{
        if(!in_array('viewCustomer', $this->permission)) {
            redirect('dashboard', 'refresh');
        }

		$this->render_template('customers/index', $this->data);	
	}

    /*
    * It Fetches the customers data from the customer table 
    * this function is called from the datatable ajax function
    */
	public function fetchCustomerData()
	{
		$result = array('data' => array());

		$data = $this->model_customers->getCustomerData();

		foreach ($data as $key => $value) {

			// button
            $buttons = '';
            if(in_array('updateCustomer', $this->permission)) {
    			$buttons .= '<a href="'.base_url('customers/update/'.$value['id']).'" class="btn btn-default"><i class="fa fa-pencil"></i></a>';
            }

            if(in_array('deleteCustomer', $this->permission)) { 
    			$buttons .= ' <button type="button" class="btn btn-default" onclick="removeFunc('.$value['id'].')" data-toggle="modal" data-target="#removeModal"><i class="fa fa-trash"></i></button>';
            }
		

            $status = ($value['status'] == 1) ? '<span class="label label-success">Active</span>' : '<span class="label label-warning">Inactive</span>';


			$result['data'][$key] = array(
				$value['customer_name'],
				$value['address'],
				$value['city'],
                $value['state'],
                $value['contact_person'],
				$value['email'],
				$status,
				$buttons
			);
		} // /foreach

		echo json_encode($result);
	}	

    /*
    * If the validation is not valid, then it redirects to the create page.
    * If the validation for each input field is valid then it inserts the data into the database 
    * and it stores the operation message into the session flashdata and display on the manage customer page
    */
	public function create()
	{
		if(!in_array('createCustomer', $this->permission)) {
            redirect('dashboard', 'refresh');
        }

		$this->form_validation->set_rules('customer_name', 'Customer name', 'trim|required');
		
	
        if ($this->form_validation->run() == TRUE) {
            // true case

        	$data = array(
                'customer_name' => $this->input->post('customer_name'),
                'address' => $this->input->post('address'),
                'city' => $this->input->post('city'),
                'state' => $this->input->post('state'),
                'contact_person' => $this->input->post('contact_person'),
                'status' => $this->input->post('status'),
            );

        	$create = $this->model_customers->create($data);
        	if($create == true) {
        		$this->session->set_flashdata('success', 'Successfully created');
        		redirect('customers/', 'refresh');
        	}
        	else {
        		$this->session->set_flashdata('errors', 'Error occurred!!');
        		redirect('customers/create', 'refresh');
        	}
        }
        else {
            // false case        	

            $this->render_template('customers/create', $this->data);
        }	
	}

    /*
    * If the validation is not valid, then it redirects to the edit customer page 
    * If the validation is successfully then it updates the data into the database 
    * and it stores the operation message into the session flashdata and display on the manage customer page
    */
	public function update($customer_id)
	{      
        if(!in_array('updateCustomer', $this->permission)) {
            redirect('dashboard', 'refresh');
        }

        if(!$customer_id) {
            redirect('dashboard', 'refresh');
        }

        $this->form_validation->set_rules('customer_name', 'Customer name', 'trim|required');

        if ($this->form_validation->run() == TRUE) {
            // true case
            
            $data = array(
                'customer_name' => $this->input->post('customer_name'),
                'address' => $this->input->post('address'),
                'city' => $this->input->post('city'),
                'state' => $this->input->post('state'),
                'contact_person' => $this->input->post('contact_person'),
                'status' => $this->input->post('status'),
            );


            $update = $this->model_customers->update($data, $customer_id);
            if($update == true) {
                $this->session->set_flashdata('success', 'Successfully updated');
                redirect('customers/', 'refresh');
            }
            else {
                $this->session->set_flashdata('errors', 'Error occurred!!');
                redirect('customers/update/'.$customer_id, 'refresh');
            }
        }
        else {
           
            // false case
            $customer_data = $this->model_customers->getCustomerData($customer_id);
            $this->data['customer_data'] = $customer_data;
            $this->render_template('customers/edit', $this->data); 
        }   
	}

    /*
    * It removes the data from the database
    * and it returns the response into the json format
    */
	public function remove()
	{
        if(!in_array('deleteCustomer', $this->permission)) {
            redirect('dashboard', 'refresh');
        }
        
        $customer_id = $this->input->post('customer_id');

        $response = array();
        if($customer_id) {
            $delete = $this->model_customers->remove($customer_id);
            if($delete == true) {
                $response['success'] = true;
                $response['messages'] = "Successfully removed"; 
            }
            else {
                $response['success'] = false;
                $response['messages'] = "Error in the database while removing the customer information";
            }
        }
        else {
            $response['success'] = false;
            $response['messages'] = "Refersh the page again!!";
        }

        echo json_encode($response);
	}

}