<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Colors extends Admin_Controller 
{
	public function __construct()
	{
		parent::__construct();

		$this->not_logged_in();

		$this->data['page_title'] = 'Colors';

		$this->load->model('model_colors');
		$this->load->model('model_brands');
		$this->load->model('model_category');
		$this->load->model('model_stores');
		$this->load->model('model_attributes');
	}

    /* 
    * It only redirects to the manage color page
    */
	public function index()
	{
        if(!in_array('viewColor', $this->permission)) {
            redirect('dashboard', 'refresh');
        }

		$this->render_template('colors/index', $this->data);	
	}

    /*
    * It Fetches the colors data from the color table 
    * this function is called from the datatable ajax function
    */
	public function fetchColorData()
	{
		$result = array('data' => array());

		$data = $this->model_colors->getColorData();

		foreach ($data as $key => $value) {

  			// button
            $buttons = '';
            if(in_array('updateColor', $this->permission)) {
    			$buttons .= '<a href="'.base_url('colors/update/'.$value['id']).'" class="btn btn-default"><i class="fa fa-pencil"></i></a>';
            }

            if(in_array('deleteColor', $this->permission)) { 
    			$buttons .= ' <button type="button" class="btn btn-default" onclick="removeFunc('.$value['id'].')" data-toggle="modal" data-target="#removeModal"><i class="fa fa-trash"></i></button>';
            }
			
			$result['data'][$key] = array(
				
				
				$value['name'],
				$value['sku'],
				$value['price'],
				$value['thickness'],
				$buttons
			);
		} // /foreach

		echo json_encode($result);
	}	

    /*
    * If the validation is not valid, then it redirects to the create page.
    * If the validation for each input field is valid then it inserts the data into the database 
    * and it stores the operation message into the session flashdata and display on the manage color page
    */
	public function create()
	{
		if(!in_array('createColor', $this->permission)) {
            redirect('dashboard', 'refresh');
        }

		$this->form_validation->set_rules('color_name', 'Color name', 'trim|required');
		$this->form_validation->set_rules('thickness', 'Thickness', 'trim|required');
		
		
	
        if ($this->form_validation->run() == TRUE) {
            // true case
        	$upload_image = $this->upload_image();

        	$data = array(
        		'name' => $this->input->post('color_name'),
        		'sku' => $this->input->post('sku'),
				'thickness' => $this->input->post('thickness'),
        		'price' => $this->input->post('price'),
        		'description' => $this->input->post('description'),
        		
        	);

        	$create = $this->model_colors->create($data);
        	if($create == true) {
        		$this->session->set_flashdata('success', 'Successfully created');
        		redirect('colors/', 'refresh');
        	}
        	else {
        		$this->session->set_flashdata('errors', 'Error occurred!!');
        		redirect('colors/create', 'refresh');
        	}
        }
        else {
            // false case

        	// attributes 
        	$attribute_data = $this->model_attributes->getActiveAttributeData();

        	$attributes_final_data = array();
        	foreach ($attribute_data as $k => $v) {
        		$attributes_final_data[$k]['attribute_data'] = $v;

        		$value = $this->model_attributes->getAttributeValueData($v['id']);

        		$attributes_final_data[$k]['attribute_value'] = $value;
        	}

        	$this->data['attributes'] = $attributes_final_data;
			$this->data['brands'] = $this->model_brands->getActiveBrands();        	
			$this->data['category'] = $this->model_category->getActiveCategroy();        	
			$this->data['stores'] = $this->model_stores->getActiveStore();        	

            $this->render_template('colors/create', $this->data);
        }	
	}

    /*
    * This function is invoked from another function to upload the image into the assets folder
    * and returns the image path
    */
	public function upload_image()
    {
    	// assets/images/color_image
        $config['upload_path'] = 'assets/images/color_image';
        $config['file_name'] =  uniqid();
        $config['allowed_types'] = 'gif|jpg|png';
        $config['max_size'] = '1000';

        // $config['max_width']  = '1024';s
        // $config['max_height']  = '768';

        $this->load->library('upload', $config);
        if ( ! $this->upload->do_upload('color_image'))
        {
            $error = $this->upload->display_errors();
            return $error;
        }
        else
        {
            $data = array('upload_data' => $this->upload->data());
            $type = explode('.', $_FILES['color_image']['name']);
            $type = $type[count($type) - 1];
            
            $path = $config['upload_path'].'/'.$config['file_name'].'.'.$type;
            return ($data == true) ? $path : false;            
        }
    }

    /*
    * If the validation is not valid, then it redirects to the edit color page 
    * If the validation is successfully then it updates the data into the database 
    * and it stores the operation message into the session flashdata and display on the manage color page
    */
	public function update($color_id)
	{      
        if(!in_array('updateColor', $this->permission)) {
            redirect('dashboard', 'refresh');
        }

        if(!$color_id) {
            redirect('dashboard', 'refresh');
        }

       $this->form_validation->set_rules('color_name', 'Color name', 'trim|required');
		$this->form_validation->set_rules('thickness', 'Thickness', 'trim|required');
        

        if ($this->form_validation->run() == TRUE) {
            // true case
            
            $data = array(
                'name' => $this->input->post('color_name'),
        		'sku' => $this->input->post('sku'),
				'thickness' => $this->input->post('thickness'),
        		'price' => $this->input->post('price'),
        		'description' => $this->input->post('description'),
            );

            
            if($_FILES['color_image']['size'] > 0) {
                $upload_image = $this->upload_image();
                $upload_image = array('image' => $upload_image);
                
                $this->model_colors->update($upload_image, $color_id);
            }

            $update = $this->model_colors->update($data, $color_id);
            if($update == true) {
                $this->session->set_flashdata('success', 'Successfully updated');
                redirect('colors/', 'refresh');
            }
            else {
                $this->session->set_flashdata('errors', 'Error occurred!!');
                redirect('colors/update/'.$color_id, 'refresh');
            }
        }
        else {
            // attributes 
            $attribute_data = $this->model_attributes->getActiveAttributeData();

            $attributes_final_data = array();
            foreach ($attribute_data as $k => $v) {
                $attributes_final_data[$k]['attribute_data'] = $v;

                $value = $this->model_attributes->getAttributeValueData($v['id']);

                $attributes_final_data[$k]['attribute_value'] = $value;
            }
            
            // false case
            $this->data['attributes'] = $attributes_final_data;
            $this->data['brands'] = $this->model_brands->getActiveBrands();         
            $this->data['category'] = $this->model_category->getActiveCategroy();           
            $this->data['stores'] = $this->model_stores->getActiveStore();          

            $color_data = $this->model_colors->getColorData($color_id);
            $this->data['color_data'] = $color_data;
            $this->render_template('colors/edit', $this->data); 
        }   
	}

    /*
    * It removes the data from the database
    * and it returns the response into the json format
    */
	public function remove()
	{
        if(!in_array('deleteColor', $this->permission)) {
            redirect('dashboard', 'refresh');
        }
        
        $color_id = $this->input->post('color_id');

        $response = array();
        if($color_id) {
            $delete = $this->model_colors->remove($color_id);
            if($delete == true) {
                $response['success'] = true;
                $response['messages'] = "Successfully removed"; 
            }
            else {
                $response['success'] = false;
                $response['messages'] = "Error in the database while removing the color information";
            }
        }
        else {
            $response['success'] = false;
            $response['messages'] = "Refersh the page again!!";
        }

        echo json_encode($response);
	}

}