<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Materials extends Admin_Controller 
{
	public function __construct()
	{
		parent::__construct();

		$this->not_logged_in();

		$this->data['page_title'] = 'Materials';

		$this->load->model('model_materials');
		$this->load->model('model_brands');
		$this->load->model('model_category');
		$this->load->model('model_stores');
		$this->load->model('model_attributes');
	}

    /* 
    * It only redirects to the manage material page
    */
	public function index()
	{
        if(!in_array('viewMaterial', $this->permission)) {
            redirect('dashboard', 'refresh');
        }

		$this->render_template('materials/index', $this->data);	
	}

    /*
    * It Fetches the materials data from the material table 
    * this function is called from the datatable ajax function
    */
	public function fetchMaterialData()
	{
		$result = array('data' => array());

		$data = $this->model_materials->getMaterialData();

		foreach ($data as $key => $value) {

            $store_data = $this->model_stores->getStoresData($value['store_id']);
			// button
            $buttons = '';
            if(in_array('updateMaterial', $this->permission)) {
    			$buttons .= '<a href="'.base_url('materials/update/'.$value['id']).'" class="btn btn-default"><i class="fa fa-pencil"></i></a>';
            }

            if(in_array('deleteMaterial', $this->permission)) { 
    			$buttons .= ' <button type="button" class="btn btn-default" onclick="removeFunc('.$value['id'].')" data-toggle="modal" data-target="#removeModal"><i class="fa fa-trash"></i></button>';
            }
			

			


			$result['data'][$key] = array(
				
				$value['name'],
				$value['price'],                
                $store_data['description'],				
				$buttons
			);
		} // /foreach

		echo json_encode($result);
	}	

    /*
    * If the validation is not valid, then it redirects to the create page.
    * If the validation for each input field is valid then it inserts the data into the database 
    * and it stores the operation message into the session flashdata and display on the manage material page
    */
	public function create()
	{
		if(!in_array('createMaterial', $this->permission)) {
            redirect('dashboard', 'refresh');
        }

		$this->form_validation->set_rules('material_name', 'Material name', 'trim|required');	
		$this->form_validation->set_rules('price', 'Price', 'trim|required');
		
	
        if ($this->form_validation->run() == TRUE) {
            // true case
        	

        	$data = array(
        		'name' => $this->input->post('material_name'),        		
        		'price' => $this->input->post('price'),        		
        		'description' => $this->input->post('description'),
        		
        	);

        	$create = $this->model_materials->create($data);
        	if($create == true) {
        		$this->session->set_flashdata('success', 'Successfully created');
        		redirect('materials/', 'refresh');
        	}
        	else {
        		$this->session->set_flashdata('errors', 'Error occurred!!');
        		redirect('materials/create', 'refresh');
        	}
        }
        else {
            // false case

        	// attributes 
        	$attribute_data = $this->model_attributes->getActiveAttributeData();

        	$attributes_final_data = array();
        	foreach ($attribute_data as $k => $v) {
        		$attributes_final_data[$k]['attribute_data'] = $v;

        		$value = $this->model_attributes->getAttributeValueData($v['id']);

        		$attributes_final_data[$k]['attribute_value'] = $value;
        	}

        	$this->data['attributes'] = $attributes_final_data;
			$this->data['brands'] = $this->model_brands->getActiveBrands();        	
			$this->data['category'] = $this->model_category->getActiveCategroy();        	
			$this->data['stores'] = $this->model_stores->getActiveStore();        	

            $this->render_template('materials/create', $this->data);
        }	
	}

    /*
    * This function is invoked from another function to upload the image into the assets folder
    * and returns the image path
    
	public function upload_image()
    {
    	// assets/images/material_image
        $config['upload_path'] = 'assets/images/material_image';
        $config['file_name'] =  uniqid();
        $config['allowed_types'] = 'gif|jpg|png';
        $config['max_size'] = '1000';

        // $config['max_width']  = '1024';s
        // $config['max_height']  = '768';

        $this->load->library('upload', $config);
        if ( ! $this->upload->do_upload('material_image'))
        {
            $error = $this->upload->display_errors();
            return $error;
        }
        else
        {
            $data = array('upload_data' => $this->upload->data());
            $type = explode('.', $_FILES['material_image']['name']);
            $type = $type[count($type) - 1];
            
            $path = $config['upload_path'].'/'.$config['file_name'].'.'.$type;
            return ($data == true) ? $path : false;            
        }
    }*/

    /*
    * If the validation is not valid, then it redirects to the edit material page 
    * If the validation is successfully then it updates the data into the database 
    * and it stores the operation message into the session flashdata and display on the manage material page
    */
	public function update($material_id)
	{      
        if(!in_array('updateMaterial', $this->permission)) {
            redirect('dashboard', 'refresh');
        }

        if(!$material_id) {
            redirect('dashboard', 'refresh');
        }

        $this->form_validation->set_rules('material_name', 'Material name', 'trim|required');     
        $this->form_validation->set_rules('price', 'Price', 'trim|required');
       

        if ($this->form_validation->run() == TRUE) {
            // true case
            
            $data = array(
                'name' => $this->input->post('material_name'),                
                'price' => $this->input->post('price'),                
                'description' => $this->input->post('description'),
                
            );

            
            

            $update = $this->model_materials->update($data, $material_id);
            if($update == true) {
                $this->session->set_flashdata('success', 'Successfully updated');
                redirect('materials/', 'refresh');
            }
            else {
                $this->session->set_flashdata('errors', 'Error occurred!!');
                redirect('materials/update/'.$material_id, 'refresh');
            }
        }
        else {
            // attributes 
            $attribute_data = $this->model_attributes->getActiveAttributeData();

            $attributes_final_data = array();
            foreach ($attribute_data as $k => $v) {
                $attributes_final_data[$k]['attribute_data'] = $v;

                $value = $this->model_attributes->getAttributeValueData($v['id']);

                $attributes_final_data[$k]['attribute_value'] = $value;
            }
            
            // false case
            $this->data['attributes'] = $attributes_final_data;
            $this->data['brands'] = $this->model_brands->getActiveBrands();         
            $this->data['category'] = $this->model_category->getActiveCategroy();           
            $this->data['stores'] = $this->model_stores->getActiveStore();          

            $material_data = $this->model_materials->getMaterialData($material_id);
            $this->data['material_data'] = $material_data;
            $this->render_template('materials/edit', $this->data); 
        }   
	}

    /*
    * It removes the data from the database
    * and it returns the response into the json format
    */
	public function remove()
	{
        if(!in_array('deleteMaterial', $this->permission)) {
            redirect('dashboard', 'refresh');
        }
        
        $material_id = $this->input->post('material_id');

        $response = array();
        if($material_id) {
            $delete = $this->model_materials->remove($material_id);
            if($delete == true) {
                $response['success'] = true;
                $response['messages'] = "Successfully removed"; 
            }
            else {
                $response['success'] = false;
                $response['messages'] = "Error in the database while removing the material information";
            }
        }
        else {
            $response['success'] = false;
            $response['messages'] = "Refersh the page again!!";
        }

        echo json_encode($response);
	}

}